<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FreelanceDetails extends Model 
{

    protected $table = 'fl_details';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('fl_users_id', 'overview', 'description', 'education', 'voice_gender', 'age_category_id', 'language_id', 'accent_id', 'average_work_hours', 'microphone_details', 'computer_hardware_software', 'special_equipment', 'experience_level_id');

    public function freelanceUser()
    {
        return $this->belongsTo('App\Models\FreelanceUsers', 'fl_user_id', 'id');
    }

    public function ageCategory()
    {
        return $this->belongsTo('App\Models\AgeCategory', 'age_category_id', 'id');
    }

    public function language()
    {
        return $this->belongsTo('App\Models\Language', 'language_id', 'id');
    }

    public function accent()
    {
        return $this->belongsTo('App\Models\Accent', 'accent_id', 'id');
    }

    public function experienceLevel()
    {
        return $this->belongsTo('App\Models\ExperienceLevel', 'experience_level_id', 'id');
    }

}